/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.compat.rei;

import com.zurrtum.create.content.processing.recipe.ProcessingOutput;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.foundation.fluid.FluidStackIngredient;
import dev.architectury.fluid.FluidStack;
import java.util.List;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.FabricIngredient;
import net.fabricmc.fabric.impl.recipe.ingredient.builtin.ComponentsIngredient;
import net.minecraft.class_10302;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_3611;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

public interface IngredientHelper {
    public static EntryIngredient createEntryIngredient(com.zurrtum.create.infrastructure.fluids.FluidStack stack) {
        return EntryIngredients.of((FluidStack)FluidStack.create((class_3611)stack.getFluid(), (long)stack.getAmount(), (class_9326)stack.getComponentChanges()));
    }

    public static EntryIngredient createEntryIngredient(FluidIngredient ingredient) {
        EntryDefinition definition = VanillaEntryTypes.FLUID.getDefinition();
        List<class_3611> fluids = ingredient.getMatchingFluids();
        EntryIngredient.Builder builder = EntryIngredient.builder((int)fluids.size());
        int amount = ingredient.amount();
        class_9326 patch = class_9326.field_49588;
        if (ingredient instanceof FluidStackIngredient) {
            FluidStackIngredient stackIngredient = (FluidStackIngredient)ingredient;
            patch = stackIngredient.components();
        }
        for (class_3611 fluid : fluids) {
            FluidStack stack = FluidStack.create((class_3611)fluid, (long)amount, (class_9326)patch);
            builder.add(EntryStack.of((EntryDefinition)definition, (Object)stack));
        }
        return builder.build();
    }

    public static List<EntryIngredient> getFluidIngredientList(List<com.zurrtum.create.infrastructure.fluids.FluidStack> stacks) {
        return stacks.stream().map(IngredientHelper::createEntryIngredient).toList();
    }

    public static Stream<EntryIngredient> getFluidIngredientStream(@Nullable FluidIngredient ingredient) {
        return ingredient == null ? Stream.empty() : Stream.of(IngredientHelper.createEntryIngredient(ingredient));
    }

    public static Stream<EntryIngredient> getFluidIngredientStream(List<FluidIngredient> ingredients) {
        if (ingredients.isEmpty()) {
            return Stream.empty();
        }
        Stream.Builder<EntryIngredient> builder = Stream.builder();
        for (FluidIngredient ingredient : ingredients) {
            builder.add(IngredientHelper.createEntryIngredient(ingredient));
        }
        return builder.build();
    }

    public static Stream<EntryIngredient> getSizedIngredientStream(List<SizedIngredient> ingredients) {
        Stream.Builder<EntryIngredient> results = Stream.builder();
        EntryDefinition definition = VanillaEntryTypes.ITEM.getDefinition();
        int size = ingredients.size();
        for (SizedIngredient ingredient : ingredients) {
            EntryIngredient.Builder builder = EntryIngredient.builder((int)size);
            ingredient.getIngredient().field_9019.forEach(stack -> builder.add(EntryStack.of((EntryDefinition)definition, (Object)new class_1799(stack, ingredient.getCount()))));
            results.add(builder.build());
        }
        return results.build();
    }

    public static List<EntryIngredient> getEntryIngredients(Stream<EntryIngredient> first, Stream<EntryIngredient> second) {
        return Stream.concat(first, second).toList();
    }

    public static EntryIngredient getInputEntryIngredient(class_1856 ingredient) {
        CustomIngredient customIngredient = ((FabricIngredient)ingredient).getCustomIngredient();
        if (customIngredient instanceof ComponentsIngredient) {
            EntryDefinition definition = VanillaEntryTypes.ITEM.getDefinition();
            List contents = ((class_10302.class_10304)customIngredient.toDisplay()).comp_3272();
            EntryIngredient.Builder builder = EntryIngredient.builder((int)contents.size());
            for (class_10302 content : contents) {
                class_10302.class_10307 display = (class_10302.class_10307)content;
                builder.add(EntryStack.of((EntryDefinition)definition, (Object)display.comp_3274()));
            }
            return builder.build();
        }
        return EntryIngredients.ofIngredient((class_1856)ingredient);
    }

    public static List<EntryIngredient> getOutputEntryIngredients(List<ProcessingOutput> outputs) {
        return outputs.stream().map(output -> EntryIngredients.of((class_1799)output.create())).toList();
    }

    public static List<Float> getOutputChances(List<ProcessingOutput> outputs) {
        return outputs.stream().map(ProcessingOutput::chance).toList();
    }
}

